import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/utils/dimensions.dart';
import 'package:play_lab/core/utils/my_color.dart';
import 'package:play_lab/core/utils/styles.dart';
import 'package:play_lab/data/controller/request/make_request_controller.dart';
import 'package:play_lab/data/model/request/search_request_response_model.dart';
import 'package:play_lab/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:play_lab/view/components/buttons/custom_rounded_button.dart';
import 'package:play_lab/view/components/custom_text_field.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';

class RequestBottomSheetBody extends StatelessWidget {
  final VoidCallback callback;
  final SearchItem item;
  const RequestBottomSheetBody({
    super.key,
    required this.item,
    required this.callback,
  });

  @override
  Widget build(BuildContext context) {
    return GetBuilder<MakeRequestController>(builder: (controller) {
      return Padding(
        padding: const EdgeInsets.all(8.0),
        child: Column(
          children: [
            const BottomSheetHeaderRow(bottomSpace: 3),
            const SizedBox(height: Dimensions.space10),
            Container(
              padding: const EdgeInsets.only(
                bottom: Dimensions.space15,
                left: Dimensions.space10,
                right: Dimensions.space10,
              ),
              alignment: Alignment.center,
              width: MediaQuery.of(context).size.width,
              decoration: BoxDecoration(borderRadius: BorderRadius.circular(5)),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    children: [
                      Text(MyStrings.whyDoYouRecommendThisItem.tr, style: boldDefault.copyWith(color: MyColor.colorWhite)),
                      SizedBox(width: 2),
                      Text("*", style: boldDefault.copyWith(color: MyColor.red)),
                    ],
                  ),
                  SizedBox(height: Dimensions.space10),
                  CustomTextField(
                    onChanged: (v) {},
                    controller: controller.detailsController,
                    maxLines: 3,
                    contentPadding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: Dimensions.space10),
                    isShowPrefixIcon: false,
                  ),
                  SizedBox(height: Dimensions.space30),
                  Row(
                    children: [
                      Expanded(
                        child: Container(
                          padding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: 17),
                          decoration: BoxDecoration(borderRadius: BorderRadius.circular(20), border: Border.all(color: MyColor.borderColor, width: 1)),
                          child: Center(child: Text(MyStrings.cancel.tr, style: boldDefault.copyWith(color: MyColor.colorWhite))),
                        ),
                      ),
                      SizedBox(width: Dimensions.space20),
                      Expanded(
                        child: CustomRoundedButton(
                          isLoading: controller.isSubmitLoading,
                          text: MyStrings.continue_.tr,
                          press: () async {
                            if (controller.detailsController.text.isEmpty) {
                              CustomSnackbar.showCustomSnackbar(errorList: [MyStrings.messageRequired], msg: [], isError: true);
                              return;
                            } else {
                              await controller.makeRequest(item);
                              callback();
                            }
                          },
                        ),
                      ),
                    ],
                  ),
                  SizedBox(height: Dimensions.space10),
                ],
              ),
            )
          ],
        ),
      );
    });
  }
}
